﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;

namespace TravelDataLib
{
  public class TravelRequestDataAccess
  {
    // Przesyłanie zgłoszenia podróży do kolejki (zapisywanie w bazie danych).
    public static void Save(TravelRequestMsg request)
    {
      string connectionString = ConfigurationManager.ConnectionStrings["TravelRequest"].ConnectionString;

      StringBuilder sql = new StringBuilder("insert into request (id, ");
      sql.Append("workflowInstanceId, requesterId, ");
      sql.Append("vendorReservationId, creationDate, travelEstimate, name, ");
      sql.Append("justification, isApproved, approvalManagerId) ");
      sql.Append("values (@id, @workflowInstanceId, @requesterId, ");
      sql.Append("@vendorReservationId, @creationDate, @travelEstimate, ");
      sql.Append("@name, @justification, @isApproved, @approvalManagerId) ");

      using (SqlConnection connection = new SqlConnection(connectionString))
      {
        connection.Open();
        SqlCommand command = connection.CreateCommand();
        command.CommandType = CommandType.Text;
        command.CommandText = sql.ToString();

        command.Parameters.Add(new SqlParameter("@id", request.Id));
        command.Parameters.Add(new SqlParameter(
          "@workflowInstanceId", request.WorkflowInstanceId));
        command.Parameters.Add(new SqlParameter(
          "@requesterId", request.RequesterId));
        command.Parameters.Add(new SqlParameter(
          "@vendorReservationId", request.VendorReservationId));
        command.Parameters.Add(new SqlParameter(
          "@creationDate", request.CreationDate));
        command.Parameters.Add(new SqlParameter(
          "@travelEstimate", request.TravelEstimate));
        command.Parameters.Add(new SqlParameter(
          "@name", request.Name));
        command.Parameters.Add(new SqlParameter(
          "@justification", request.Justification));
        command.Parameters.Add(new SqlParameter("@isApproved", false));
        if (request.ApprovalManagerId == null)
        {
          request.ApprovalManagerId = "brak";
        }
        command.Parameters.Add(new SqlParameter("@approvalManagerId", 
          request.ApprovalManagerId));

        command.ExecuteNonQuery();
      }
    }

    public static void Complete(TravelRequestMsg request)
    {
      string connectionString = ConfigurationManager.ConnectionStrings["TravelRequest"].ConnectionString;

      StringBuilder sql = new StringBuilder("update request set ");
      sql.Append("isApproved=@isApproved, ");
      sql.Append("approvalManagerId=@approvalManagerId, isComplete=1 ");
      sql.Append("where id = @id ");

      using (SqlConnection connection = new SqlConnection(connectionString))
      {
        connection.Open();
        SqlCommand command = connection.CreateCommand();
        command.CommandType = CommandType.Text;
        command.CommandText = sql.ToString();

        command.Parameters.Add(new SqlParameter("@id", request.Id));
        command.Parameters.Add(new SqlParameter("@isApproved", 
          request.IsApproved ? 1 : 0));
        command.Parameters.Add(new SqlParameter("@approvalManagerId", 
          request.ApprovalManagerId));

        command.ExecuteNonQuery();
      }
    }
  }
}
